--war früher ab2__b_iu__termini
DROP TRIGGER IF EXISTS ab2__b_iu__termini ON ab2;
DROP FUNCTION IF EXISTS ab2__b_iu__termini() CASCADE;
-- Trigger ab2__b_iu__a2_interm
-- aus 0200 Tables\J abk.sql
CREATE OR REPLACE FUNCTION ab2__b_iu__a2_interm() RETURNS TRIGGER AS $$
  DECLARE

      _prefix varchar := format( 'ab2__b_iu__a2_interm AG %s -', new.a2_n );
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN
      IF new.a2_at IS NOT NULL AND new.a2_et IS NOT NULL THEN
          new.a2_interm := TRUE; -- aktueller AG ist einterminiert
          /*
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% aktueller AG ist einterminiert: a2_interm = TRUE', _prefix;
          END IF;
          */
      ELSE
          new.a2_interm := FALSE;
          /*
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% aktueller AG ist NICHT einterminiert: a2_interm = FALSE', _prefix;
          END IF;
          */
      END IF;
      --

      RETURN new;

  END$$LANGUAGE plpgsql;
--
  DROP TRIGGER IF EXISTS ab2__b_iu__a2_interm ON ab2;
  CREATE TRIGGER ab2__b_iu__a2_interm
      BEFORE INSERT OR UPDATE
      OF a2_at, a2_et
      ON ab2
      FOR EACH ROW
      EXECUTE PROCEDURE ab2__b_iu__a2_interm();
--